function hapticToolDemo()

%% Define paths to sample volume data

leaf128CubedDir = 'demoData\672clippedA128Cubed';
% drosophila256CubedDir = 'demoData\drosophila (291gfp1+txr+vis)_256Cubed';

volumeDirs{1}= leaf128CubedDir;
% volumeDirs{2} = drosophila256CubedDir;


%% Load volumes and construct transforms for them

volumes = getHTVolume();
transforms = getHTTransform();
volumeCounter = 1;
voxelSize = [0.001, 0.001, 0.001];
noOfPlanes = 256;

for i = 1:length(volumeDirs)
    
    if ischar(volumeDirs{i})

        files = dir([volumeDirs{i}, filesep, '*.png']);
        files = {files.name};

        % Get image dimensions and number of images to determine required space
        im = imread([char(volumeDirs{i}), filesep, files{1}]);
        dims = size(im);
        noOfSlices = length(files);

        % Swap size of third and fourth dimension in order to have the rgb vector
        % along the fourth dimension. Hence we later allocate a m x n x p x 3
        % matrix
        dims = [dims(1:2), length(files), dims(3)];

        noOfElements = prod(dims);
        disp(['Volume dimensions: ', sprintf('%d x %d x %d x %d', dims)]);
        disp(['Volume (uint8) size in MB: ', sprintf('%d', noOfElements / 2^20)])

        %% Allocate memory
        volume = ones(dims, 'uint8');

        %% Load images
        for j=1:length(files)
            im = imread([volumeDirs{i}, filesep, files{j}]);
            volume(:, :, j, :) = im(:, :, :);
        end

        % Construct a transform for each volume, set its name and use
        % defaults for the remaining fields
        t = getHTTransform();
        t.name = sprintf('transform%i', volumeCounter);
        transforms(volumeCounter) = t;
             
        v = getHTVolume();
        v.name = sprintf('volume%i', volumeCounter);
        v.parentTransform = sprintf('transform%i', volumeCounter);
        v.volume = volume;
        v.planes = noOfPlanes;
        v.voxelSize = voxelSize;
        v.hapticChannel = 'green';
        volumes(volumeCounter) = v;
        
        volumeCounter = volumeCounter + 1;
    end
end


%% Add manipulated template point set from disk

load('demoData\points128.pts', '-mat', 'points')
points128 = points;
colours128 = zeros(size(points128));
colours128(1, :) = 1;
interactionMode128 = 'move';

p = getHTPointSet();
p.name = 'pointSet128';
p.parentTransform = 'transform1';
p.points = points128;
p.colours = colours128;
p.interactionMode = interactionMode128;
pointSets(1) = p;

%% Arrange volumes side by side
xDims = [];
totalWidth = 0;
spacing = 0.02;

for k = 1:length(volumes)
    l = size(volumes(k).volume, 2);
    totalWidth = totalWidth + l * voxelSize(1);
    
    if k ~= length(volumes)
        totalWidth = totalWidth + spacing;
    end
    
    xDims = [xDims l]; 
end

offset = -totalWidth / 2;

for m = 1:length(transforms)
    offset = offset + xDims(m) * voxelSize(1) / 2;
    
    if m ~= 1
        offset = offset + spacing;
        offset = offset + xDims(m - 1) * voxelSize(1) / 2;
    end
    
    transforms(m).translation(1) = offset;
end

%% Run haptic viewer after having set all the necessary variables

[transformsOut, volumesOut, pointSetsOut] =...
    hapticTool(transforms, volumes, pointSets);


%% Save the returned point set to disk

% points = pointSetsOut(1).points;
% save('points128.pts', 'points');



